typedef struct tagImportDirectory {
    DWORD    dwRVAFunctionNameList;
    DWORD    dwUseless1;
    DWORD    dwUseless2;
    DWORD    dwRVAModuleName;
    DWORD    dwRVAFunctionAddressList;
} IMAGE_IMPORT_MODULE_DIRECTORY;


#define PEFHDROFFSET(a) ((LPVOID)((BYTE*)a + \
                                  ((PIMAGE_DOS_HEADER)a)->e_lfanew + 4))
#define OPTHDROFFSET(a) ((LPVOID)((BYTE*)a + \
                                  ((PIMAGE_DOS_HEADER)a)->e_lfanew + 4 + \
                                  sizeof (IMAGE_FILE_HEADER)))
#define SECHDROFFSET(a) ((LPVOID)((BYTE*)a + \
                                  ((PIMAGE_DOS_HEADER)a)->e_lfanew + 4 + \
                                  sizeof (IMAGE_FILE_HEADER) + 224))

/*
  there are two groups of functions here:
  1) functions that work with PE file (prefix PEfile)
  2) functions that work with PE image (prefix PEimage)
  the difference is that sections in image are placed
  at their virtual addresses
*/

extern IMAGE_SECTION_HEADER*
            PEfileDirectoryEntryToSectionHeader( void* File, int Entry );
#define PEimageDirectoryEntryToSectionHeader PEfileDirectoryEntryToSectionHeader
/*
  this function returns pointer to the section header that corresponds
  data directory entry
  NULL is returned in case of error
*/

extern IMAGE_SECTION_HEADER*
            PEfileVAToSectionHeader( void* File, DWORD VA );
#define PEimageVAToSectionHeader PEfileVAToSectionHeader
/*
  returns pointer to the section header that virtual address is within
  the section
  NULL is returned in case of error
*/

extern IMAGE_SECTION_HEADER*
            PEfileGetCodeSectionHeader( void* File );
#define PEimageGetCodeSectionHeader PEfileGetCodeSectionHeader
/*
  returns pointer to the code section header
  NULL is returned in case of error
*/

extern void* PEimageGetEntryPoint( void* Image );
/*
  returns address of entry point
*/

extern FARPROC PEimageProcAddress( void* Image, char* ProcName );
/*
  similar to GetProcAddress
*/

#define PEimageGetResource( i, t, r, s ) PEGetResource( i, FALSE, t, r, s )
#define PEfileGetResource( i, t, r, s ) PEGetResource( i, TRUE, t, r, s )

extern void* PEGetResource( void* Image, BOOL IsFile,
                                     WORD ResType, WORD ResId,
                                     DWORD* ResourceSize );
/*
  this function returns pointer to the resource data and writes
  resource size into variable pointed by ResourceSize;
  ResourceSize may be NULL;
  function returns NULL if required resource not found;
*/
